/*****	main.c	: housekeeping for dmc.c ******/

#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <string.h>
#include "dmc.h"

char  *info = "Dynamic Markov Compression ( DMC ) ";

static void usage_exit( char *argv )
{
   char *filename, *extension;

	filename = strrchr( argv, '\\' );	/* find '\' */
   if ( filename == NULL )
   	filename = strrchr( argv, '/' );
   if ( filename == NULL )
   	filename = strrchr( argv, ':' );
   if ( filename != NULL )
		filename++;							/* strip off the path */
   else
   	filename = argv;
	extension= strrchr( filename, '.' );
	if ( extension!= NULL )
		*extension= '\0';
   printf( "\nUsage:  %s [-c/e] in-file out-file \n", filename );
	printf("\n%s is for compression ! ", filename );
   printf("\n%s", info );
	printf("\nThe switches -c means compress \( default \),");
   printf("\n             -e means expand,");
   exit( 0 );
}   /* usage_exit() */

#ifndef SEEK_END
#define SEEK_END 2
#endif

static uint32 file_size( char *name )
{
	uint32 size;
   FILE *file;

   file = fopen( name, "r" );
   if (file == NULL) {
   	return 0L;
   }
	fseek( file, 0L, SEEK_END );	/* points to END OF FILE */
	size = ftell( file );			/* get current file pointer */
   fclose( file );
	return size;
}	/* file_size() */


/*
 * This routine prints out the compression ratios after the input
 * and output files have been closed.
 */
static void print_ratios( char *input, char *output )
{
	long input_size;
	long output_size;
	float ratio;

	input_size = file_size( input );
	if ( input_size == 0 ) {
		input_size = 1;
   }
	output_size = file_size( output );
	ratio = ( float ) output_size * 100 / input_size;
   if ( output_size == 0 )
   	output_size = 1;
   printf( "\nCompressed Size in bytes : %12ld", output_size );
   printf( "\nOriginal   Size in bytes : %12ld", input_size );
	printf( "\nCompression ratio        : %12.1f%%\n", ratio );
}

static void	compress(char	*argv[])
{
	FILE *input,  *output;
	long file_length,  file_size();				/* in main.c */
	int c;

	if ( ( input = fopen(*argv++, "rb") ) == NULL ){
		printf("\n%s doesn't exist ", *(argv-1) );
		exit( 1 );
	}
	output = fopen(*argv, "wb");
	file_length = filelength(fileno(input));
	put_file_length(file_length, output);
	initialize_model();			/* initialize the model */
	initialize_encoder();
   encode(input, output);
   flush_encoder(output);
   fclose(input);
   fclose(output);
}	/* compress */


static void uncompress(char *argv[])
{

	FILE	*input, *output;
	long	file_length;

   if ((input = fopen( *argv++, "rb" ))==NULL) {
		printf("\n%s doesn't exist ", *(argv-1));
		exit(1);
	}
	output = fopen(*argv, "wb");

	file_length = get_file_length(input);
	initialize_model();			/* initialize the model */
	initialize_decoder(input);
	decode(file_length, input, output);
   fclose(input);
   fclose(output);

}	/* umcompress */

int main( int argc, char *argv[] )
{
	char	*p[10], c;

	if ( argc < 3 )
		usage_exit( argv[ 0 ] );
   argv++;
	c = *(argv[0]+1);
	if ( *argv[0] != '-' ){
   	compress( argv );
      print_ratios ( *argv, *(argv+1) );
   } else {
		if ( argc < 4 )
      	usage_exit( argv[0] );
      ++argv;
		if ( c == 'c' || c == 'C' ){
			compress( argv  );
			print_ratios ( *argv, *(argv+1) );
		} else if ( c == 'e' || c == 'E' ){
			uncompress( argv );
			print_ratios ( *(argv+1), *argv );
		} else
			usage_exit( argv[0] );
	}	/* else */
   return 0;
}	/* main */
