/*
** Main CRC generator program
*/

#include <stdio.h>
#include "crc.h"

void PrintCRCTable( char *Name, unsigned short *PTable );

main( int argc, char *argv[] )
{
  unsigned short *PTable;
  unsigned short Accum;
  int i;

  PTable = mk_crctbl( CRC16_REV, crcrevhware );
  PrintCRCTable( "Rev CRC-16", PTable );
  free( PTable );
  
  PTable = mk_crctbl( CRC16, crchware );
  PrintCRCTable( "CRC-16", PTable );
  free( PTable );
  
  PTable = mk_crctbl( CRCCCITT, crchware );
  PrintCRCTable( "CRC-CCITT", PTable );
  free( PTable );
  
  PTable = mk_crctbl( CRCCCITT_REV, crcrevhware );
  PrintCRCTable( "Rev CRC-CCITT", PTable );
  free( PTable );
  
  
}


void
PrintCRCTable( char *Name, unsigned short *PTable )
{
  int i = 0;

  printf( "%s", Name );
  while ( i < 255 ) {
    if ( i % 8 == 0 ) {
      printf( "\n" );
    }
    printf( "0x%04x, ", *PTable++ );
    i++;
  }
  printf( "0x%04x\n\n", *PTable );
  
}

