/*
** History:
** 000: 21 Jul 90, RBH - Extracted from 'C programmers Guide to Serial
**                       Communications, Joe Campbell, Howard. W. Sams 1987.
*/

#define CRCCCITT     0x1021         /* CCITT polynomial */
#define CRCCCITT_REV 0x8408         /* reverse CCITT */
#define CRC16        0x8005         /* CRC-16 */
#define CRC16_REV    0xA001         /* Reverse CRC-16 */

#ifdef USE_MACROS

#define crcupdate( d, a, t )  (*(a) = (*(a) << 8) ^ (t)[(*(a) >> 8) ^ (d)])
#define crcupdate16(d,a,t) *(a) = ((*(a)>>8) ^ (t)[ (*a) ^ (d)) &0x00ff])

#else

  extern void crcupdate(
    unsigned short data,
    unsigned short *accum,
    unsigned short *crctab
  );

#endif

extern unsigned short crchware();
extern unsigned short crcrevhware();
extern unsigned short *mk_crctbl();

