/* Code extracted from C programmers Guide to Serial Programming by Joe Campbell,
/* Howard W. Sams 1987

#include <stdlib.h>
#include <string.h>
#include "crc.h"

/*
** Forward CRC generator
*/
unsigned short
crchware( data, genpoly, accum )
  unsigned short data;
  unsigned short genpoly;
  unsigned short accum;
{
  static int i;
  
  data <<= 8;
  for ( i = 8; i > 0 ; i-- ) {
    /* if msb of data XOR Accum */
    if ((data ^ accum) & 0x8000)  {
      accum = ( accum << 1 ) ^ genpoly;
    }
    else {
      accum <<= 1;
    }
    data <<= 1;
  }
  return accum;
}

/*
** Reverse CRC generator
*/
unsigned short
crcrevhware( data, genpoly, accum )
  unsigned short data;
  unsigned short genpoly;
  unsigned short accum;
{
  static int i;

  data <<= 1;
  for ( i = 8; i > 0 ; i-- ) {
    data >>= 1;
    if ((data ^ accum) &0001) {
      accum = (accum >> 1 ) ^ genpoly;
    }
    else {
      accum >>= 1;
    }
  }
  return accum;
}

/*
** Make a CRC table
*/
unsigned short
*mk_crctbl( poly, crcfn )
  unsigned short poly;
  unsigned short (*crcfn)();
{
  unsigned short *crctp;
  int i;

  if ( ( crctp = (unsigned short *) malloc( 256*sizeof(unsigned))) != NULL) {
    for ( i = 0; i < 256; i++ ) {
      crctp[i] = (*crcfn)(i, poly, 0);  /* 0 .. 255 */
    }
  }
  return crctp;
}

#ifndef USE_MACROS 

  /*
  ** Update the accumulator
  */
  void
  crcupdate( data, accum, crctab )
    unsigned short data;
    unsigned short *accum;
    unsigned short *crctab;
  {
    static short CombValue;

    CombValue = ( *accum >> 8 ) ^ data;
    *accum = (*accum << 8 ) ^ crctab[ CombValue ];

  }
#endif

